/*global define */
/*jslint white: true */

/*
	EventGraphPileItem:

	This object defines the event graph pile item, which represents a referenced to a event recording file.
*/

define(["src/utils", "src/math/mathUtils"],
function(utils, mathUtils) {
	"use strict";

	function EditedKeyframeBuckets(inBucketMap, inBucketDuration, inLastBucketIndex, inEventGraphKeyArray, inSrcFileDuration) {

		this.pEditedKeyframeBuckets = { 
			bucketMap			: inBucketMap,
			duration			: inBucketDuration,
			nLastBucketIndex	: inLastBucketIndex,
			eventGraphKeyArray	: inEventGraphKeyArray,
			srcFileDuration		: inSrcFileDuration,
		};
	}
	
	utils.mixin(EditedKeyframeBuckets, {
		getDuration : function () {
			return this.pEditedKeyframeBuckets.duration;
		},

		getLastBucketIndex : function () {
			return this.pEditedKeyframeBuckets.nLastBucketIndex;
		},

		getBucketMap : function () {
			return this.pEditedKeyframeBuckets.bucketMap;
		},
		
		getEventGraphKeyArray : function () {
			return this.pEditedKeyframeBuckets.eventGraphKeyArray || [];
		},
		
		getSrcFileDuration : function () {
			return this.pEditedKeyframeBuckets.srcFileDuration;
		},
		
		getBucket : function (inBucketIndex) {
			return this.getBucketMap()[inBucketIndex];
		},

		getBucketIndexFromTime : function (inTimeF) {
			return Math.floor(inTimeF / this.getDuration()) + 1;
		},
		
		getTimeFromBucketIndex : function (inBucketIndex) {
			return (inBucketIndex - 1) * this.getDuration();
		},

		getContinuationValueIfAvailable : function (inBucket, inTimeF) {
			var d = inBucket.tContinuationData;
			if (d) {
				if (d.firstKeyframe !== undefined && d.previousKeyframe !== undefined) {
					if (inTimeF >= d.previousKeyframe.t && inTimeF <= d.firstKeyframe.t) {
						if (d.bFormatAsHoldKeys) {
							return d.previousKeyframe.v;
						} else {
							var dt = d.firstKeyframe.t - d.previousKeyframe.t;
							if (dt) {
								return mathUtils.lerp(d.previousKeyframe.v, d.firstKeyframe.v, (inTimeF - d.previousKeyframe.t) / dt);
							} else {
								return d.firstKeyframe.v;
							}
						}
					}
				} else if (d.firstKeyframe !== undefined) {
					// return undefined, since we either within keyframe range, or before the first actual value.
				} else if (d.previousKeyframe !== undefined) {
					if (inTimeF >= d.previousKeyframe.t) {
						return d.previousKeyframe.v;
					}
				}
			}
		},
		
	});


	return EditedKeyframeBuckets;
});

